function SuperMenu()
{
  if (this instanceof SuperMenu == false) {
    return new SuperMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
SuperMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
SuperMenu.prototype.execute = function(x, y, w, h, timex, timey, sel) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = sel;
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);
   
      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + 8 + (selection - top_selection) * (1.5) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      if (timex >= 0)
      {
      TheTime();
      font.drawText(timex, timey, Game.time);
      }

      FlipScreen();
      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
	    OverRide(Accept,false);
            item.callback();
            return;
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }
        }
      EatKey();
      break;
      } // end handle input
    }
  } // end with
}

function OrderMenu()
{

  if (this instanceof OrderMenu == false) {
    return new OrderMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
OrderMenu.prototype.addItem = function(name, callback, x, y, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  item.x = x - 16;
  item.y = y + 16;
  this.items[this.items.length] = item;
}

// execute
OrderMenu.prototype.execute = function(x, y, w, h, timex, timey, sel) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);
  
    if (sel == undefined)
    {
    var selection = tempnum;
    }
    else
    {
    var selection = sel;
    }
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the menu items

      // draw the selection arrow
      arrow.blit(items[selection].x, items[selection].y);
      
      if (timex >= 0)
      {
      TheTime();
      font.drawText(timex, timey, Game.time);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
	    OverRide(Accept,false);
            SetDelayScript(0, item.callback);
            return;
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }
        }
      EatKey();
      break;
      } // end handle input
    }
  } // end with
}



function StatusMenu()
{
  if (this instanceof StatusMenu == false) {
    return new StatusMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
StatusMenu.prototype.addItem = function(name, callback, x,color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.x        = x;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
StatusMenu.prototype.execute = function(x, y, w, h, sel, script) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var text_width = 16;
    var shown_items = Math.floor(h / text_height);

    var selection = sel;
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);
   
      for (i=0; i < items.length; i++)
      {
      // draw the menu items
          font.drawText(items[i].x + 32 + i*4*text_width, y + 8,  items[i].name);
      }
      // draw the selection arrow
      
      arrow.blit(items[selection].x + selection*4*text_width, y);

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
	    OverRide(Accept,false);

            if (script == true)
            {
            SetDelayScript(0, item.callback);
            }
            else
            {
            item.callback();
            }
            return;
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_RIGHT: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_LEFT: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }
        }
      EatKey()
      break;
      } // end handle input
    }
  } // end with
}



function SkillMenu()
{
  if (this instanceof SkillMenu == false) {
    return new SkillMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
SkillMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
SkillMenu.prototype.execute = function(x, y, w, h, sel, top) {
  with (this) {
    window_style.drawWindow(x, y - 24, w, h + 24);
    GFont.drawText(x + 32, y- 16, "Skill Name");
    GFont.drawText(x + 270, y- 16, "SP Cost");//added 50 here;
    GFont.drawText(x + 398, y- 16, "Mp Use");
    var background = GrabImage(0,0, GetScreenWidth(), GetScreenHeight());
    var text_height = font.getHeight();
    var shown_items = 11;

    var selection = sel;
    var top_selection = top;
    var thethingy = 0;
    while (true) {
     // draw background
     background.blit(0,0);
      // draw the window


      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) 
        {
          if (player[partymem[Game.tempnum].person].skills[items[i+top_selection].name].learned == false)
          {
          font.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
          font.drawText(x + 300,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][1]);
          font.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
          }
          else
          {
          GYFont.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
          GYFont.drawText(x + 270,     y + 8 + (1.5)* i * text_height,     "Learned");
          GYFont.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
          }
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + 8 + (selection - top_selection) * (1.5) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y-24);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items*(1.5) - down_arrow.height);
      }
      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
		  if (player[partymem[Game.tempnum].person].skills[selection].learned == true)
		  {
		  OverRide(Beep,false);
		  break;
		  }
		  else if (player[partymem[Game.tempnum].person][42] >= Skill[player[partymem[Game.tempnum].person].skills[items[selection].name].num][1])
		  {
		  OverRide(Accept,false);

			if (Skill[player[partymem[Game.tempnum].person].skills[items[selection].name].num][19] == undefined || Skill[player[partymem[Game.tempnum].person].skills[items[selection].name].num][19] == "")
			{
			}
			else
			{
			background.blit(0,0);
			window_style.drawWindow(x, y - 24, w, h + 24);

			GFont.drawText(x + 32, y- 16, "Skill Name");
			GFont.drawText(x + 270, y- 16, "SP Cost");
			GFont.drawText(x + 398, y- 16, "Mp Use");
				for (var i = 0; i < shown_items; i++) {
					if (i < items.length) 
					{
						if (player[partymem[Game.tempnum].person].skills[items[i+top_selection].name].learned == false)
						{
						font.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
						font.drawText(x + 300,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][1]);
						font.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
						}
					else
					{
					GYFont.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
					GYFont.drawText(x + 270,     y + 8 + (1.5)* i * text_height,     "Learned");
					GYFont.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
					}
				}
				}

			arrow.blit(x, y + 8 + (selection - top_selection) * (1.5) * text_height);

			if (top_selection > 0) {
			up_arrow.blit(x + w - up_arrow.width, y-24);
			}
			if (top_selection + shown_items < items.length) {
			down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items*(1.5) - down_arrow.height);
			}
			}

		  UpgradeSkill(selection, partymem[Game.tempnum].person, top_selection);
		  return;
		  }
		  else
		  {
		  OverRide(Beep,false);
		  break;
		  }
		
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

		case KEY_PAGEUP:
		{
			if (selection <= 0)
			{
		        OverRide(Beep,false);
			}
			else
			{
		        OverRide(Mmove,false);
			selection -= shown_items;
			top_selection -= shown_items;
			thethingy = selection - top_selection;
				if (top_selection <= 0 && selection > -1*shown_items + 1 && top_selection > -1*shown_items)
				{
				top_selection = 0;
				selection = thethingy;
				}
				else if (top_selection <=  0)
				{
				selection = 0;
				top_selection = 0;
				}
			}
		break;
		}
		case KEY_PAGEDOWN:
		{
			if (selection >= items.length - 1)
			{
			OverRide(Beep,false);
			}
			else
			{
		        OverRide(Mmove,false);
			selection += shown_items;
			top_selection += shown_items;
			thethingy = selection - top_selection;
				if (top_selection > items.length - 1)
				{
				selection = items.length - 1;
				top_selection = items.length - shown_items;
				}
				else if (top_selection  > items.length - 1 - shown_items)
				{
				top_selection = items.length - shown_items;
				selection = top_selection + thethingy;
				}
			}
		break;
		}

          case KEY_SPACE: 
          {
	    OverRide(Accept,false);
	
	      background.blit(0,0);
	      window_style.drawWindow(x, y - 24, w, h + 24);

	      GFont.drawText(x + 32, y- 16, "Skill Name");
	      GFont.drawText(x + 270, y- 16, "SP Cost");
	      GFont.drawText(x + 398, y- 16, "Mp Use");

	      for (var i = 0; i < shown_items; i++) {
		if (i < items.length) 
		{
		  if (player[partymem[Game.tempnum].person].skills[items[i+top_selection].name].learned == false)
		  {
		  font.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
		  font.drawText(x + 300,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][1]);
		  font.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
		  }
		  else
		  {
		  GYFont.drawText(x + 32,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][0]);
		  GYFont.drawText(x + 270,     y + 8 + (1.5)* i * text_height,     "Learned");
		  GYFont.drawText(x + 430,     y + 8 + (1.5)* i * text_height,     Skill[player[partymem[Game.tempnum].person].skills[items[i + top_selection].name].num][2]);
		  }
		}
	      }

	      arrow.blit(x, y + 8 + (selection - top_selection) * (1.5) * text_height);

	      if (top_selection > 0) {
		up_arrow.blit(x + w - up_arrow.width, y-24);
	      }
	      if (top_selection + shown_items < items.length) {
		down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items*(1.5) - down_arrow.height);
	      }
		
		if (Skill[player[partymem[Game.tempnum].person].skills[selection].num][19] == undefined || Skill[player[partymem[Game.tempnum].person].skills[selection].num][19] == "" || player[partymem[Game.tempnum].person].skills[selection].learned == false)
		{
		DisplaySkillInfo(player[partymem[Game.tempnum].person].skills[selection].num);
		}
		else
		{
		Skill[player[partymem[Game.tempnum].person].skills[selection].num][19]();
		ClearScreen();
		}
          break;
          }
        }
      EatKey()
      break;
      } // end handle input
    }
  } // end with
}

function SelectCounter()
{
	if (player[partymem[Game.tempnum].person][90] <= 0)
	{
	player[partymem[Game.tempnum].person][90] = player[partymem[Game.tempnum].person].skills[0].num;
	}
WindowStyle.drawWindow(85, 235, 490, 165);
WindowStyle.drawWindow(85, 205, 490, 20);
Font.drawText(87,207, "Current Counter: " + Skill[player[partymem[Game.tempnum].person][90]][0]);
var background = GrabImage(0,0,GetScreenWidth(), GetScreenHeight());
var top_selection = 0;
var selection = 0;
var shown_items = 7;
var arrow = LoadImage("Arrow3.png");

	while(true)
	{
	background.blit(0,0);
		for (t=0; t<shown_items+1; t++)
		{
			if (player[partymem[Game.tempnum].person].skills[t+top_selection].learned == true && (Skill[player[partymem[Game.tempnum].person].skills[t+top_selection].num][18] == true || Skill[player[partymem[Game.tempnum].person].skills[t+top_selection].num][18] == undefined))
			{
			Font.drawText(115, 240 + t*20, Skill[player[partymem[Game.tempnum].person].skills[t+top_selection].num][0])
			}
			else// if (player[partymem[Game.tempnum].person].skills[t+top_selection].learned == false)
			{
			GYFont.drawText(115, 240 + t*20, Skill[player[partymem[Game.tempnum].person].skills[t+top_selection].num][0])
			}
		}

	arrow.blit(85,240 + 20*(selection-top_selection));
	FlipScreen();

		while(AreKeysLeft())
		{
			switch(GetKey())
			{
				case KEY_DOWN: 
				{
					if (selection == player[partymem[Game.tempnum].person].skills[0].number + 1)
					{
					OverRide(Beep, false);
					}
					else
					{
					OverRide(Mmove, false);
					selection++;
						if (selection - top_selection > shown_items)
						{
						top_selection++;
						}
					}
				break;
				}
				case KEY_UP: 
				{
					if (selection == 0)
					{
					OverRide(Beep, false);
					}
					else
					{
					OverRide(Mmove, false);
					selection--;
						if (selection < top_selection)
						{
						top_selection--;
						}
					}
				break;
				}
				case KEY_ENTER: 
				{
					if (player[partymem[Game.tempnum].person].skills[selection].learned == true && (Skill[player[partymem[Game.tempnum].person].skills[selection].num][18] == true || Skill[player[partymem[Game.tempnum].person].skills[selection].num][18] == undefined))
					{
					OverRide(Accept, false);
					player[partymem[Game.tempnum].person][90] = player[partymem[Game.tempnum].person].skills[selection].num;
					return;
					}
					else
					{
					OverRide(Beep, false);
					}
				break;
				}
				case KEY_ESCAPE:
				{
				OverRide(Cancel, false);
				return;
				}
			}
		}
	}
EatKey();
}

function EquipMenu()
{
  if (this instanceof EquipMenu == false) {
    return new EquipMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
EquipMenu.prototype.addItem = function(name, callback, X, Y, type, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.X = X;
  item.Y = Y;
  item.type = type;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
EquipMenu.prototype.execute = function(x, y, w, h, sel, preview) {
  with (this) {
    if (preview == true)
    {
    DisplayStats();
    }
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();

    var selection = sel;

    while (true) {
      // draw background
      background.blit(0,0)

      if (preview == true)
      {
      DisplayStats2(items[selection].type, -1)
      }
      // draw the menu items
      for (var i = 0; i < 6; i++) {
        if (i < items.length) 
        {
          font.drawText(items[i].X, items[i].Y,  items[i].name);
        }
      }

      // draw the selection arrow
      arrow.blit(items[selection].X-32, items[selection].Y-4);

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {

	    OverRide(Accept,false);

            var item = items[selection];
            Game.seltemp = selection;
            SetDelayScript(0, item.callback);
            return;
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: 
          {
	    OverRide(Mmove,false);
            if (selection < items.length - 1) 
            {
              selection++;
            }
            else
            {
            selection = 0;
            }

            break;
          }

          case KEY_RIGHT: 
          {
	    OverRide(Mmove,false);
            if (selection < 3) 
            {
              selection = selection + 3;
            }
            break;
          }

          case KEY_LEFT: 
          {
	    OverRide(Mmove,false);
            if (selection > 2) 
            {
              selection = selection - 3;
            }
            break;
          }


          case KEY_UP: {
	    OverRide(Mmove,false);
            if (selection > 0) {
              selection--;
            }
            else
            {
            selection = items.length - 1;
            }

            break;
          }
        }
      EatKey();
      break;
      } // end handle input
    }
  } // end with
}



function GMenu()
{
  if (this instanceof GMenu == false) {
    return new GMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
GMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
GMenu.prototype.execute = function(x, y, w, h, sel, type, top) {
  with (this) {
    DisplayStats();
    window_style.drawWindow(x, y, w, h);
    var background = GrabImage(0,0,GetScreenWidth(), GetScreenHeight());
    var text_height = font.getHeight()*1.5;
    var shown_items = Math.floor(h / text_height);
    var Type = type;
    var selection = sel;
	if (top == undefined)
	{
	var top_selection = 0;
	}
	else
	{
	var top_selection = top;
	}

    while (true) 
    {
    background.blit(0,0);

    if (ItemPlace[selection].num == -1 || (Item[ItemPlace[selection].num].type2 == Type && player[Game.temp][Item[ItemPlace[selection].num].type] > 0))
    {
      DisplayStats2(Type, ItemPlace[selection].num);
    }

      // draw the menu items
      for (var i = 0; i < shown_items; i++) 
      {
          if (ItemPlace[i + top_selection].num == -1)
          {
          font.drawText(x + 32,     y + 8 + i * text_height,    "");
          }
          else if (Item[ItemPlace[i+top_selection].num].type2 == Type )
          {
            if (player[Game.temp][Item[ItemPlace[i + top_selection].num].type] > 0)
            {
            font.drawText(x + 32,     y + 8 + i * text_height,    Item[ItemPlace[i+top_selection].num].name);
            }
            else
            {
            GYFont.drawText(x + 32,     y + 8 + i * text_height,    Item[ItemPlace[i+top_selection].num].name);
            }
          }
          else
          {
          GYFont.drawText(x + 32,     y + 8 + i * text_height,    Item[ItemPlace[i+top_selection].num].name);
          }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];    
	    Game.tempitem = selection;
	    Game.temptop = top_selection;
            if (ItemPlace[selection].num == -1)
            {
  	      OverRide(Accept,false);
              SetDelayScript(0, Equip_2(ItemPlace[selection].num, Type));
              return;
            }
            else if (Item[ItemPlace[selection].num].type2 == Type )
            {
              if (player[Game.temp][Item[ItemPlace[selection].num].type] > 0)
              {
	        OverRide(Accept,false);
                SetDelayScript(0, Equip_2(ItemPlace[selection].num, Type));
                return;
              }
              else
              {
	        OverRide(Beep,false);
                break;            
              }
            }
            else
            {
              OverRide(Beep,false);
              break;
            }

      
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel,false);
	    Game.tempitem = selection;
	    Game.temptop = top_selection;          
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
            OverRide(Mmove,false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
            OverRide(Mmove,false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }




          case KEY_PAGEDOWN: {
            OverRide(Mmove,false);
            if (selection < items.length - shown_items) {
              selection = selection + shown_items;
              if (selection >= top_selection + shown_items) {
                top_selection = top_selection + shown_items;
              }
              if (top_selection > Game.itemsnum - shown_items)
              {
              top_selection = Game.itemsnum - shown_items;
              }
            }
            else
            {
            selection = items.length - 1;
            top_selection = items.length - shown_items;
            }
            break;
          }

          case KEY_PAGEUP: {
            OverRide(Mmove,false);
            if (selection > shown_items) {
              selection = selection - shown_items;
              if (selection < top_selection) {
                top_selection = top_selection - shown_items;
                if (top_selection < 0)
                {
                top_selection = 0;
                }
              }
            }
            else
            {
            selection = 0;
            top_selection = 0;
            }
            break;
          }



        }
      EatKey()
      break;
      } // end handle input
    }
  } // end with
}

function DrugMenu()
{
  if (this instanceof DrugMenu == false) {
    return new DrugMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
DrugMenu.prototype.addItem = function(name, num) {

  var item = new Object;
  item.name     = name;
  item.num = num;
  this.items[this.items.length] = item;
}

// execute
DrugMenu.prototype.execute = function(x, y, w, h, shown) {
  with (this) {

    var text_height = font.getHeight();
    if (shown < Math.floor(h/text_height))
    {
    var shown_items = shown;
    }
    else
    {
    var shown_items = Math.floor(h / text_height) -1;
    }
    var selection = 0;
    var top_selection = 0;
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    while (true) 
    {
      // draw background
      background.blit(0, 0);

      // draw the menu items
      if (items.length > 0)
      {
        for (var i = 0; i < shown_items; i++) 
        {
          Font.drawText(x, y + 16 + i * text_height, Item[items[i+top_selection].name].name);
          Font.drawText(x+300, y + 16 + i * text_height, player[Game.tempnum].addict[items[i+top_selection].num].days);
        }
      }
      else
      {
        Font.drawText(x, y + 20, "None");
      }

      // draw the selection arrow
      arrow.blit(x-32, y + 12 + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ESCAPE: {
            OverRide(Cancel,false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            OverRide(Mmove,false);
            if (selection < items.length - 1) {
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            OverRide(Mmove,false);
            if (selection > 0) {
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }
        }
      EatKey()
      break;
      } // end handle input
    }
  } // end with
}




























function CoolMenu()
{
  if (this instanceof CoolMenu == false) {
    return new CoolMenu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = LoadImage("Arrow_Up.png");
  this.down_arrow      = LoadImage("Arrow_Down.png");
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
CoolMenu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
CoolMenu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = 0;
    var top_selection = 0;
    Game.temp1st = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.setColorMask(Black);
          font.drawText(x + 16 + 1, y+2 + i * text_height + 1, items[i + top_selection].name);
          font.setColorMask(items[i + top_selection].color);
          font.drawText(x + 16,     y+2 + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
            var item = items[selection];
	    item.callback();
            return;
          }

          case KEY_ESCAPE: {
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
              selection++;
  	      Game.temp1st++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
              selection--;
  	      Game.temp1st--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }

  } // end with
}



function Menu()
{
  if (this instanceof Menu == false) {
    return new Menu();
  }

  // default properties
  this.font            = GetSystemFont()
  this.window_style    = GetSystemWindowStyle()
  this.arrow           = GetSystemArrow();
  this.up_arrow        = GetSystemUpArrow();
  this.down_arrow      = GetSystemDownArrow();
  this.escape_function = function() { }

  this.items = new Array();
}

// add item
Menu.prototype.addItem = function(name, callback, color) {

  if (color == undefined) {
    color = White;
  }

  var item = new Object;
  item.name     = name;
  item.callback = callback;
  item.color    = color;
  this.items[this.items.length] = item;
}

// execute
Menu.prototype.execute = function(x, y, w, h) {
  with (this) {
    var background = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

    var text_height = font.getHeight();
    var shown_items = Math.floor(h / text_height);

    var selection = 0;
    var top_selection = 0;

    while (true) {
      // draw background
      background.blit(0, 0);

      // draw the window
      window_style.drawWindow(x, y, w, h);

      // draw the menu items
      for (var i = 0; i < shown_items; i++) {
        if (i < items.length) {
          font.setColorMask(Black);
          font.drawText(x + 16 + 1, y + i * text_height + 1, items[i + top_selection].name);
          font.setColorMask(items[i + top_selection].color);
          font.drawText(x + 16,     y + i * text_height,     items[i + top_selection].name);
        }
      }

      // draw the selection arrow
      arrow.blit(x, y + (selection - top_selection) * text_height);

      // draw the up and down arrows if necessary
      if (top_selection > 0) {
        up_arrow.blit(x + w - up_arrow.width, y);
      }
      if (top_selection + shown_items < items.length) {
        down_arrow.blit(x + w - down_arrow.width, y + text_height * shown_items - down_arrow.height);
      }

      FlipScreen();

      // handle keypresses
      while (AreKeysLeft()) {
        switch (GetKey()) {
          case KEY_ENTER: {
	    OverRide(Accept, false);
            var item = items[selection];
            item.callback();
            return;
          }

          case KEY_ESCAPE: {
	    OverRide(Cancel, false);
            escape_function();
            return;
          }

          case KEY_DOWN: {
            if (selection < items.length - 1) {
	    OverRide(Mmove, false);
              selection++;
              if (selection >= top_selection + shown_items) {
                top_selection++;
              }
            }
            break;
          }

          case KEY_UP: {
            if (selection > 0) {
	    OverRide(Mmove, false);
              selection--;
              if (selection < top_selection) {
                top_selection--;
              }
            }
            break;
          }

        }
      } // end handle input
    }

  } // end with
}
